using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class Rule
{
    [JsonProperty("arg")]
    public IEnumerable<string> Arg { get; set; }

    [JsonProperty("children")]
    public IEnumerable<Rule> Children { get; set; }

    [JsonProperty("criterion")]
    public SmartLinkCriterion Criterion { get; set; }

    [JsonProperty("end")]
    public string End { get; set; }

    [JsonProperty("match ")]
    public IEnumerable<string> Match { get; set; }

    [JsonProperty("start")]
    public string Start { get; set; }

    [JsonProperty("regexp ")]
    public string Regexp { get; set; }

    [JsonProperty("total_clicks ")]
    public int? TotalClicks { get; set; }

    [JsonProperty("unique_clicks  ")]
    public int? UniqueClicks { get; set; }

    [JsonProperty("url")]
    public string Url { get; set; }
}